/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.CRFObjectiveFunctionGradient;
import calhoun.analysis.crf.SemiMarkovSetup;
import calhoun.analysis.crf.io.IntInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.CacheProcessorDeluxe;
import calhoun.analysis.crf.solver.MaximumLikelihoodGradient;
import calhoun.analysis.crf.solver.MaximumLikelihoodSemiMarkovGradient;
import calhoun.analysis.crf.solver.check.AllSparseLengthCacheProcessor;
import calhoun.analysis.crf.solver.check.BasicCRFGradient;
import calhoun.analysis.crf.solver.check.NormalizedCRFGradient;
import calhoun.analysis.crf.test.TestFeatureManager;
import calhoun.util.AbstractTestCase;
import calhoun.util.ColtUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FunctionEvalTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(FunctionEvalTest.class);

    public void testGradientEdgeTrivial() throws Exception {
        this.doLikelihoodTest(1, IntInput.prepareData("0\n0"), -0.6931, 0.0, -0.6931, 0.0);
    }

    public void testGradientEdgeShort() throws Exception {
        double a = Math.log(0.3333333333333333);
        double b = Math.log(0.2222222222222222);
        this.doLikelihoodTest(1, IntInput.prepareData("00\n00"), a / 2.0, 0.1155, -0.45815, 0.0693);
        this.doLikelihoodTest(1, IntInput.prepareData("000\n000"), b / 3.0, 0.154);
    }

    public void testGradStateFunc() throws Exception {
        this.doLikelihoodTest(0, IntInput.prepareData("001111\n001111"), -0.6365166666666667, 0.0, -0.68525, -0.09241833333333332);
    }

    public void testTwoFeaturesTrivial() throws Exception {
        this.doLikelihoodTest(2, IntInput.prepareData("00\n00"), -0.97295, -0.495);
        this.doLikelihoodTest(2, IntInput.prepareData("00\n00\n00\n00"), -0.97295, -0.4951);
    }

    public void testTwoFeaturesNonTrivial() throws Exception {
        this.doLikelihoodTest(2, IntInput.prepareData("00001010100100111000\n00001010100100111000\n00001010100100111001\n00001010100100111001\n"), -0.9761, -0.28137500000000004);
    }

    void doLikelihoodTest(int mmNum, List<? extends TrainingSequence<?>> data, double f, double g) {
        this.doLikelihoodTest(mmNum, data, f, g, false);
    }

    void doLikelihoodTest(int mmNum, List<? extends TrainingSequence<?>> data, double f, double g, double h, double i) {
        this.doLikelihoodTest(mmNum, data, f, g, false);
        this.doLikelihoodTest(mmNum, data, h, i, true);
    }

    void doLikelihoodTest(int mmNum, List<? extends TrainingSequence<?>> data, double f, double g, boolean skewedWeights) {
        double[] dArray;
        TestFeatureManager m = new TestFeatureManager(mmNum);
        if (skewedWeights) {
            double[] dArray2 = new double[2];
            dArray2[0] = 2.0;
            dArray = dArray2;
            dArray2[1] = 0.5;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 1.0;
            dArray = dArray3;
            dArray3[1] = 1.0;
        }
        double[] weights = dArray;
        double[] grad = new double[2];
        short[] max = new short[2];
        CRFObjectiveFunctionGradient gradFunc = new BasicCRFGradient();
        gradFunc.setTrainingData(m, data);
        double val = gradFunc.apply(weights, grad);
        log.info((Object)("Grad(Basic): " + ColtUtil.format(grad)));
        FunctionEvalTest.assertEquals((double)f, (double)val, (double)0.001);
        FunctionEvalTest.assertEquals((double)g, (double)grad[0], (double)0.001);
        gradFunc = new NormalizedCRFGradient();
        gradFunc.setTrainingData(m, data);
        val = gradFunc.apply(weights, grad);
        log.info((Object)("Grad(Norm): " + ColtUtil.format(grad)));
        FunctionEvalTest.assertEquals((double)f, (double)val, (double)0.001);
        FunctionEvalTest.assertEquals((double)g, (double)grad[0], (double)0.001);
        AllSparseLengthCacheProcessor cacheProcessor = new AllSparseLengthCacheProcessor();
        cacheProcessor.setAllPaths(true);
        gradFunc = new MaximumLikelihoodGradient();
        cacheProcessor = new AllSparseLengthCacheProcessor();
        cacheProcessor.setAllPaths(true);
        ((MaximumLikelihoodGradient)gradFunc).setCacheProcessor(cacheProcessor);
        gradFunc.setTrainingData(m, data);
        val = gradFunc.apply(weights, grad);
        log.info((Object)("Grad(Cache,Valid Paths): " + ColtUtil.format(grad)));
        FunctionEvalTest.assertEquals((double)f, (double)val, (double)0.001);
        FunctionEvalTest.assertEquals((double)g, (double)grad[0], (double)0.001);
        gradFunc = new MaximumLikelihoodGradient();
        cacheProcessor = new AllSparseLengthCacheProcessor();
        cacheProcessor.setAllPaths(false);
        ((MaximumLikelihoodGradient)gradFunc).setCacheProcessor(cacheProcessor);
        gradFunc.setTrainingData(m, data);
        val = gradFunc.apply(weights, grad);
        log.info((Object)("Grad(Cache): " + ColtUtil.format(grad)));
        FunctionEvalTest.assertEquals((double)f, (double)val, (double)0.001);
        FunctionEvalTest.assertEquals((double)g, (double)grad[0], (double)0.001);
        Arrays.fill(max, (short)1);
        gradFunc = new MaximumLikelihoodSemiMarkovGradient();
        cacheProcessor = new AllSparseLengthCacheProcessor();
        cacheProcessor.setAllPaths(false);
        cacheProcessor.setSemiMarkovSetup(new SemiMarkovSetup(max));
        ((MaximumLikelihoodSemiMarkovGradient)gradFunc).setCacheProcessor(cacheProcessor);
        gradFunc.setTrainingData(m, data);
        val = gradFunc.apply(weights, grad);
        log.info((Object)("Grad(Semi-cache): " + ColtUtil.format(grad)));
        FunctionEvalTest.assertEquals((double)f, (double)val, (double)0.001);
        FunctionEvalTest.assertEquals((double)g, (double)grad[0], (double)0.001);
        max = new short[2];
        Arrays.fill(max, (short)20);
        m = new TestFeatureManager(mmNum, 1);
        gradFunc = new MaximumLikelihoodSemiMarkovGradient();
        CacheProcessorDeluxe cacheProcessor1 = new CacheProcessorDeluxe();
        cacheProcessor1.setAllPaths(false);
        cacheProcessor1.setSemiMarkovSetup(new SemiMarkovSetup(max, true));
        ((MaximumLikelihoodSemiMarkovGradient)gradFunc).setCacheProcessor(cacheProcessor1);
        gradFunc.setTrainingData(m, data);
        val = gradFunc.apply(weights, grad);
        log.info((Object)("Grad(Length): " + ColtUtil.format(grad)));
        FunctionEvalTest.assertEquals((double)f, (double)val, (double)0.001);
        FunctionEvalTest.assertEquals((double)g, (double)grad[0], (double)0.001);
        m = new TestFeatureManager(mmNum, 2);
        Arrays.fill(max, (short)20);
        gradFunc = new MaximumLikelihoodSemiMarkovGradient();
        cacheProcessor = new AllSparseLengthCacheProcessor();
        cacheProcessor.setAllPaths(false);
        cacheProcessor.setSemiMarkovSetup(new SemiMarkovSetup(max, true));
        ((MaximumLikelihoodSemiMarkovGradient)gradFunc).setCacheProcessor(cacheProcessor);
        gradFunc.setTrainingData(m, data);
        val = gradFunc.apply(weights, grad);
        log.info((Object)("Grad(Length): " + ColtUtil.format(grad)));
        FunctionEvalTest.assertEquals((double)f, (double)val, (double)0.001);
        FunctionEvalTest.assertEquals((double)g, (double)grad[0], (double)0.001);
    }
}

