/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.StringInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.check.ArrayFeatureList;
import calhoun.util.AbstractTestCase;
import fmph.features.mitochondrion1.GeneConstraintsMitochondrion1;
import java.util.ArrayList;
import java.util.List;

public class GeneConstraintsInterval13Test
extends AbstractTestCase {
    public void testGeneConstraintsTraining() throws Exception {
        Conrad crf = new Conrad("test/input/interval13/config/markov.xml");
        List<? extends TrainingSequence<Character>> train1 = StringInput.prepareData("000000002222222666661111100000000\nACACACACATGCACAGTCAGACACATAGACACA\n00000000077777CCCCCC7777000000000000\nACACACTTACACACCTACACACATACACACACACAC\n");
        System.out.println(train1);
        GeneConstraintsMitochondrion1 gc = new GeneConstraintsMitochondrion1();
        ArrayList train2 = new ArrayList();
        gc.train(0, crf.getModel(), train2);
    }

    public void testGeneConstraintsEvaluation() throws Exception {
        Conrad crf = new Conrad("test/input/interval13/config/markov.xml");
        GeneConstraintsMitochondrion1 gc = new GeneConstraintsMitochondrion1();
        List<TrainingSequence<?>> data = crf.getInputHandler().readTrainingData("test/input/interval13/data/oneGeneTrain.interval13.txt");
        crf.trainFeatures(data);
        gc.train(0, crf.getModel(), (List<? extends TrainingSequence<? extends Character>>)data);
        ArrayFeatureList result = new ArrayFeatureList(crf.getModel());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 3, 1, 4, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 3, 2, 5, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 3, 3, 6, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 3, 1, 5, (FeatureList)result);
        GeneConstraintsInterval13Test.assertFalse((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 18, 7, 10, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 18, 8, 12, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 18, 9, 11, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 18, 7, 11, (FeatureList)result);
        GeneConstraintsInterval13Test.assertFalse((boolean)result.isValid());
        result.clear();
        gc.evaluateNode((InputSequence<? extends Character>)data.get(0).getInputSequence(), 7, 3, (FeatureList)result);
        GeneConstraintsInterval13Test.assertFalse((boolean)result.isValid());
        result.clear();
        gc.evaluateNode((InputSequence<? extends Character>)data.get(0).getInputSequence(), 7, 2, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateNode((InputSequence<? extends Character>)data.get(0).getInputSequence(), 6, 3, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 7, 3, 3, (FeatureList)result);
        GeneConstraintsInterval13Test.assertFalse((boolean)result.isValid());
        result.clear();
        gc.evaluateEdge((InputSequence<? extends Character>)data.get(0).getInputSequence(), 7, 4, 4, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
        result.clear();
        gc.evaluateNode((InputSequence<? extends Character>)data.get(0).getInputSequence(), 4, 8, (FeatureList)result);
        GeneConstraintsInterval13Test.assertFalse((boolean)result.isValid());
        result.clear();
        gc.evaluateNode((InputSequence<? extends Character>)data.get(0).getInputSequence(), 4, 7, (FeatureList)result);
        GeneConstraintsInterval13Test.assertTrue((boolean)result.isValid());
    }
}

