/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.test.CRFIOTest;
import calhoun.util.AbstractTestCase;
import calhoun.util.ColtUtil;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MatrixOperationsTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(CRFIOTest.class);
    boolean debug = log.isDebugEnabled();

    public void testMatrixExponential() throws Exception {
        System.out.println("Hello world");
        double[][] X = new double[4][4];
        X[0][0] = -0.002050871;
        X[0][1] = 5.984135E-4;
        X[0][2] = 9.34839E-4;
        X[0][3] = 5.176184E-4;
        X[1][0] = 7.120564E-4;
        X[1][1] = -0.002164514;
        X[1][2] = 9.34839E-4;
        X[1][3] = 5.176184E-4;
        X[2][0] = 7.120564E-4;
        X[2][1] = 5.984135E-4;
        X[2][2] = -0.001828088;
        X[2][3] = 5.176184E-4;
        X[3][0] = 7.120564E-4;
        X[3][1] = 5.984135E-4;
        X[3][2] = 9.34839E-4;
        X[3][3] = -0.002245309;
        DenseDoubleMatrix2D S = new DenseDoubleMatrix2D(4, 4);
        S.assign(X);
        System.out.println("The matrix S is: ");
        System.out.println(ColtUtil.format((DoubleMatrix2D)S));
        DenseDoubleMatrix2D T = new DenseDoubleMatrix2D(4, 4);
        ColtUtil.exponentiate_real_matrix((DoubleMatrix2D)S, (DoubleMatrix2D)T, 200);
        System.out.println("The matrix T (the computed exponential of S) is: ");
        System.out.println(ColtUtil.format((DoubleMatrix2D)T));
        double[][] Y = new double[4][4];
        Y[0][0] = 0.998;
        Y[0][1] = 6.0E-4;
        Y[0][2] = 9.0E-4;
        Y[0][3] = 5.0E-4;
        Y[1][0] = 7.0E-4;
        Y[1][1] = 0.9978;
        Y[1][2] = 9.0E-4;
        Y[1][3] = 5.0E-4;
        Y[2][0] = 7.0E-4;
        Y[2][1] = 6.0E-4;
        Y[2][2] = 0.9982;
        Y[2][3] = 5.0E-4;
        Y[3][0] = 7.0E-4;
        Y[3][1] = 6.0E-4;
        Y[3][2] = 9.0E-4;
        Y[3][3] = 0.9978;
        DenseDoubleMatrix2D U = new DenseDoubleMatrix2D(4, 4);
        U.assign(Y);
        System.out.println("The matrix U (the computed exponential of S using Matlab's U = expm(S)) is: ");
        System.out.println(ColtUtil.format((DoubleMatrix2D)U));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                MatrixOperationsTest.assertEquals((double)T.getQuick(i, j), (double)U.getQuick(i, j), (double)0.001);
            }
        }
    }
}

