/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.io.InputHandlerInterleaved;
import calhoun.analysis.crf.io.IntInput;
import calhoun.analysis.crf.io.OutputHandlerGeneCallStats;
import calhoun.analysis.crf.io.StringInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.MaximumLikelihoodGradient;
import calhoun.analysis.crf.solver.SimplexOptimizer;
import calhoun.analysis.crf.solver.StandardOptimizer;
import calhoun.analysis.crf.solver.Viterbi;
import calhoun.analysis.crf.test.TestFeatureManager;
import calhoun.analysis.crf.test.ZeroOrderManager;
import calhoun.util.AbstractTestCase;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NonGradientTest
extends AbstractTestCase {
    static final Log log = LogFactory.getLog(NonGradientTest.class);
    boolean debug = log.isDebugEnabled();

    public void testNoGradient() throws Exception {
        SimplexOptimizer opt = new SimplexOptimizer();
        opt.setStepSize(1.0E-6);
        List<? extends TrainingSequence<?>> data = IntInput.prepareData("001111\n001111");
        opt.setObjectiveFunction(new MaximumLikelihoodGradient());
        double[] weights = opt.optimize(new TestFeatureManager(0), data);
        NonGradientTest.assertEquals((double)1.0, (double)weights[0], (double)1.0E-5);
    }

    public void testConvergence() throws Exception {
        SimplexOptimizer opt = new SimplexOptimizer();
        opt.setStepSize(1.0E-6);
        opt.setMaxIters(2);
        opt.setRequireConvergence(true);
        opt.setObjectiveFunction(new MaximumLikelihoodGradient());
        List<? extends TrainingSequence<?>> data = IntInput.prepareData("001111\n001111");
        boolean ex = false;
        try {
            opt.optimize(new TestFeatureManager(0), data);
        }
        catch (Exception e) {
            ex = true;
        }
        NonGradientTest.assertTrue((boolean)ex);
    }

    public void testGradientEdge() throws Exception {
        List<? extends TrainingSequence<?>> data = IntInput.prepareData("00110\n00110");
        MaximumLikelihoodGradient obj = new MaximumLikelihoodGradient();
        SimplexOptimizer opt = new SimplexOptimizer();
        opt.setObjectiveFunction(obj);
        double[] weightsSimplex = opt.optimize(new TestFeatureManager(1), data);
        StandardOptimizer stdOpt = new StandardOptimizer();
        stdOpt.setObjectiveFunction(obj);
        double[] weightsStandard = stdOpt.optimize(new TestFeatureManager(1), data);
        this.assertArrayEquals(weightsStandard, weightsSimplex, 1.0E-5);
    }

    public void testViterbi() throws Exception {
        double[] weights = new double[]{-9.639248, 9.659248, -9.98204, 10.00204, -15.34077, 28.54132, -13.01635, -3.040209, -3.383001, 19.47956};
        Conrad crf = new Conrad();
        crf.setModel(new ZeroOrderManager());
        crf.setInputHandler(new InputHandlerInterleaved(new StringInput()));
        OutputHandlerGeneCallStats stats = new OutputHandlerGeneCallStats(crf.getModel(), crf.getInputHandler());
        stats.setWriteTrainingData(true);
        crf.setOutputHandler(stats);
        crf.setInference(new Viterbi());
        crf.trainFeatures("test/input/zeroOrderTest.txt");
        crf.setWeights(weights);
        crf.test("test/input/zeroOrderTest.txt", "test/working/zeroOrderPredicted.txt");
        this.assertFilesMatch("test/output/zeroOrderPredicted.txt", "test/working/zeroOrderPredicted.txt");
    }
}

