/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.features.supporting.LogProbLookup;
import calhoun.analysis.crf.io.InputSequenceCharacter;
import calhoun.analysis.crf.io.StringInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.AbstractTestCase;
import fmph.features.mitochondrion1.ReferenceBasePredictorMitochondrion1;
import java.util.List;

public class ReferenceBasePredictorTest
extends AbstractTestCase {
    public void testLogProbLookupEasy() throws Exception {
        InputSequenceCharacter seq = new InputSequenceCharacter("CTCTCTCTCTCTCTCTCTC");
        LogProbLookup lp1 = new LogProbLookup(0, 1.0);
        for (int pos = 0; pos < seq.length(); ++pos) {
            lp1.increment(seq, pos, true);
        }
        lp1.finalize();
        ReferenceBasePredictorTest.assertEquals((double)lp1.lookup(seq, 0, true), (double)-0.737598, (double)0.001);
        ReferenceBasePredictorTest.assertEquals((double)lp1.lookup(seq, 0, false), (double)-3.135494, (double)0.001);
        ReferenceBasePredictorTest.assertEquals((double)lp1.lookup(seq, 1, true), (double)-0.832909, (double)0.001);
        ReferenceBasePredictorTest.assertEquals((double)lp1.lookup(seq, 1, false), (double)-3.135494, (double)0.001);
        LogProbLookup lp2 = new LogProbLookup(0, 0.25);
        for (int pos = 0; pos < seq.length(); ++pos) {
            lp2.increment(seq, pos, true);
        }
        lp2.finalize();
        ReferenceBasePredictorTest.assertEquals((double)lp2.lookup(seq, 0, true), (double)-0.66845, (double)0.001);
        ReferenceBasePredictorTest.assertEquals((double)lp2.lookup(seq, 0, false), (double)-4.38203, (double)0.001);
        ReferenceBasePredictorTest.assertEquals((double)lp2.lookup(seq, 1, true), (double)-0.77111, (double)0.001);
        ReferenceBasePredictorTest.assertEquals((double)lp2.lookup(seq, 1, false), (double)-4.38203, (double)0.001);
    }

    public void testLogProbLookupHard() throws Exception {
        InputSequenceCharacter seq1 = new InputSequenceCharacter("ACGTNCGTGTTCCATGGTAAC");
        InputSequenceCharacter seq2 = new InputSequenceCharacter("GNTTACA");
        LogProbLookup lp1 = new LogProbLookup(2, 1.0);
        for (int pos = 0; pos < seq1.length(); ++pos) {
            lp1.increment(seq1, pos, true);
            lp1.increment(seq1, pos, false);
        }
        lp1.finalize();
        ReferenceBasePredictorTest.assertEquals((double)lp1.lookup(seq2, 0, false), (double)0.0, (double)0.001);
        ReferenceBasePredictorTest.assertEquals((double)lp1.lookup(seq2, 3, true), (double)0.0, (double)0.001);
        ReferenceBasePredictorTest.assertEquals((double)lp1.lookup(seq2, 4, true), (double)-1.09861, (double)0.001);
    }

    public void testReferenceBasePredictor() throws Exception {
        String configFile = "test/input/interval13/config/markov.xml";
        Conrad crf = new Conrad(configFile);
        List<? extends TrainingSequence<Character>> train1 = StringInput.prepareData("000000002222222666661111100000000\nACACACACATGCACAGTCAGACACATAGACACA\n00000000077777CCCCCC7777000000000000\nACACACTTACACACCTACACACATACACACACACAC\n");
        System.out.println(train1);
        ReferenceBasePredictorMitochondrion1 bp = new ReferenceBasePredictorMitochondrion1();
        bp.train(0, crf.getModel(), (List<? extends TrainingSequence<? extends Character>>)train1);
    }
}

