/*
 * Decompiled with CFR 0.152.
 */
package calhoun.seq;

import calhoun.util.Assert;
import calhoun.util.PrimeUtil;

public class RepeatedSubsequence {
    public static boolean isRollingMatch(String a, String b) {
        int len = a.length();
        if (len != b.length()) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        StringBuffer sb = new StringBuffer(a);
        for (int i = 1; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                sb.setCharAt(j, a.charAt((i + j) % len));
            }
            if (!sb.toString().equals(b)) continue;
            return true;
        }
        return false;
    }

    public static String calc(String seq) {
        int pos = seq.length();
        int maxPrime = seq.length() / 2 + 1;
        int[] primes = PrimeUtil.primesToAtLeastN(maxPrime);
        int i = 1;
        while (primes[i] <= maxPrime) {
            boolean repeat;
            while (pos % primes[i] == 0 && (repeat = RepeatedSubsequence.checkRepeat(seq, pos / primes[i], primes[i]))) {
                pos /= primes[i];
            }
            ++i;
        }
        String ret = seq.substring(0, pos);
        if (RepeatedSubsequence.checkRepeat(ret, 1, ret.length())) {
            ret = ret.substring(0, 1);
        }
        Assert.a(RepeatedSubsequence.checkRepeat(seq, ret.length(), seq.length() / ret.length()));
        return ret;
    }

    public static boolean checkRepeat(String s, int l, int n) {
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            for (int j = 1; j < n; ++j) {
                if (c == s.charAt(i + j * l)) continue;
                return false;
            }
        }
        return true;
    }
}

