/*
 * Decompiled with CFR 0.152.
 */
package calhoun.seq;

import calhoun.seq.FastaSequence;
import calhoun.util.Assert;
import java.io.Serializable;

public class SimpleFastaSequence
implements FastaSequence,
Serializable {
    private static final long serialVersionUID = 3541355741077645447L;
    String header;
    private String sequence;
    private byte[] quality = null;

    public SimpleFastaSequence() {
    }

    public SimpleFastaSequence(String header, String sequence) {
        this.header = header;
        this.sequence = sequence;
    }

    public void setHeader(String s) {
        this.header = s;
    }

    public void setSequence(String s) {
        if (this.quality != null && s != null) {
            Integer sl = new Integer(s.length());
            Integer ql = new Integer(this.quality.length);
            Assert.a(sl.equals(ql), "Quality (", ql, ") and sequence (", sl, ") for ", this.header == null ? "" : this.header, " are not the same size.");
        }
        this.sequence = s;
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    public boolean hasSequence() {
        return this.sequence != null;
    }

    public boolean hasQuality() {
        return this.quality != null;
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public String getSequence(int start, int stop) {
        Assert.a(this.sequence != null, "No sequence available for ", this.header);
        return this.sequence.substring(start - 1, stop);
    }

    @Override
    public int getLength() {
        if (this.sequence != null) {
            return this.sequence.length();
        }
        Assert.a(this.quality != null, "No sequence or quality available for ", this.header);
        return this.quality.length;
    }

    @Override
    public byte[] getQuality() {
        return this.quality;
    }

    public void setQuality(byte[] q) {
        if (q != null && this.sequence != null) {
            Assert.a(this.sequence.length() == q.length, this.header, ": Quality (", new Integer(q.length), ") and sequence (", new Integer(this.sequence.length()), ") for ", this.header, " are not the same size.");
        }
        this.quality = q;
    }
}

