/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import calhoun.util.FileDiff;
import calhoun.util.FileUtil;
import calhoun.util.XmlDiff;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTestCase
extends TestCase {
    private static final Log log = LogFactory.getLog(AbstractTestCase.class);
    private static Set basicTypes = new HashSet();

    public AbstractTestCase() {
    }

    public AbstractTestCase(String arg0) {
        super(arg0);
    }

    public void runBare() throws Throwable {
        try {
            log.info((Object)("Running Test: " + ((Object)((Object)this)).getClass().getName() + " " + this.getName()));
            this.setUp();
        }
        catch (Throwable ex) {
            log.error((Object)(this.getName() + ": "), ex);
            throw ex;
        }
        try {
            this.runTest();
        }
        catch (Throwable ex) {
            log.error((Object)(this.getName() + ": "), ex);
            throw ex;
        }
        finally {
            this.tearDown();
        }
    }

    private void failCompare(String name, Object expect, Object actual) throws Exception {
        AbstractTestCase.fail((String)("Property compare failed on " + name + ".  Expected: " + expect + " Actual: " + actual));
    }

    public void assertXmlFilesMatch(String template, String actual) throws Exception {
        String result = XmlDiff.compareFiles(template, actual);
        log.debug((Object)("Result: " + result));
        if (result != null) {
            log.warn((Object)result);
            AbstractTestCase.fail();
        }
    }

    public void assertArrayEquals(byte[] a, byte[] b) {
        for (int i = 0; i < a.length; ++i) {
            AbstractTestCase.assertEquals((byte)a[i], (byte)b[i]);
        }
    }

    public void assertArrayEquals(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            AbstractTestCase.assertEquals((Object)a[i], (Object)b[i]);
        }
    }

    public void assertArrayEquals(double[] a, double[] b, double tolerance) {
        for (int i = 0; i < a.length; ++i) {
            AbstractTestCase.assertEquals((double)a[i], (double)b[i], (double)tolerance);
        }
    }

    public void assertArrayEquals(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            AbstractTestCase.assertEquals((int)a[i], (int)b[i]);
        }
    }

    public void assertBeginsWith(byte[] a, byte[] b) {
        for (int i = 0; i < a.length; ++i) {
            AbstractTestCase.assertEquals((byte)a[i], (byte)b[i]);
        }
    }

    public void assertEndsWith(byte[] a, byte[] b) {
        for (int i = 0; i < a.length; ++i) {
            AbstractTestCase.assertEquals((byte)a[i], (byte)b[b.length - a.length + i]);
        }
    }

    public void assertEquals(byte[] a, byte[] b) {
        AbstractTestCase.assertEquals((int)a.length, (int)b.length);
        for (int i = 0; i < a.length; ++i) {
            AbstractTestCase.assertEquals((byte)a[i], (byte)b[i]);
        }
    }

    public void assertStringEquals(String[] expected, List l) {
        this.assertStringEquals(expected, l.toArray(new String[l.size()]));
    }

    public void assertStringEquals(String[] expected, String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (expected.length <= i) continue;
            AbstractTestCase.assertEquals((String)expected[i], (String)strings[i]);
        }
        AbstractTestCase.assertEquals((int)expected.length, (int)strings.length);
    }

    public void assertFilesMatch(String expected, String actual) throws Exception {
        FileDiff diff = new FileDiff(expected, actual);
        boolean mismatch = diff.execute();
        AbstractTestCase.assertFalse((String)diff.toString(), (boolean)mismatch);
    }

    public void assertFlatFileRecordsMatch(String expected, String actual) throws Exception {
        String s = FileUtil.fileRecordCompare(expected, actual);
        AbstractTestCase.assertNull((String)s, (Object)s);
    }

    static {
        basicTypes.add(String.class);
        basicTypes.add(Byte.class);
        basicTypes.add(Byte.TYPE);
        basicTypes.add(Boolean.class);
        basicTypes.add(Boolean.TYPE);
        basicTypes.add(Short.class);
        basicTypes.add(Short.TYPE);
        basicTypes.add(Integer.class);
        basicTypes.add(Integer.TYPE);
        basicTypes.add(Long.class);
        basicTypes.add(Long.TYPE);
        basicTypes.add(Character.class);
        basicTypes.add(Character.TYPE);
        basicTypes.add(Double.class);
        basicTypes.add(Double.TYPE);
        basicTypes.add(Float.class);
        basicTypes.add(Float.TYPE);
    }
}

