/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import calhoun.util.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class RangeMap
implements Serializable {
    public static final long serialVersionUID = 413339879647819935L;
    SortedMap map = new TreeMap();
    Map objectList = new HashMap();

    public int size() {
        return this.objectList.size();
    }

    public Set values() {
        return this.objectList.keySet();
    }

    public int getStart() {
        return this.size() == 0 ? 0 : (Integer)this.map.firstKey();
    }

    public int getStop() {
        return this.size() == 0 ? 0 : (Integer)this.map.lastKey() - 1;
    }

    public SortedMap getMap() {
        return Collections.unmodifiableSortedMap(this.map);
    }

    public Map getObjectList() {
        return Collections.unmodifiableMap(this.objectList);
    }

    public List getDisjointRegions() {
        return this.getRegions(true);
    }

    public List getRegions() {
        return this.getRegions(false);
    }

    public List getRegions(boolean splitDisjointRegions) {
        ArrayList<Interval> list = new ArrayList<Interval>();
        Interval currentInterval = null;
        for (Map.Entry entry : this.map.entrySet()) {
            List currentValue = (List)entry.getValue();
            int currentKey = (Integer)entry.getKey();
            if (currentValue.size() == 0) {
                Assert.a(currentInterval != null, "Multiple 0 intervals in a row were detected.");
                currentInterval.stop = currentKey - 1;
                list.add(currentInterval);
                currentInterval = null;
                continue;
            }
            if (currentInterval != null) {
                boolean disjoint = true;
                Iterator i = currentValue.iterator();
                while (i.hasNext()) {
                    if (!currentInterval.elements.contains(i.next())) continue;
                    disjoint = false;
                }
                if (disjoint && splitDisjointRegions) {
                    currentInterval.stop = currentKey - 1;
                    list.add(currentInterval);
                    currentInterval = null;
                }
            }
            if (currentInterval == null) {
                currentInterval = new Interval();
                currentInterval.start = currentKey;
                currentInterval.elements = new HashSet();
            }
            currentInterval.elements.addAll(currentValue);
        }
        Assert.a(currentInterval == null, "RangeMap did not end with a 0 entry.");
        return list;
    }

    public List getIntervals() {
        ArrayList<Interval> list = new ArrayList<Interval>();
        Interval currentInterval = null;
        for (Map.Entry entry : this.map.entrySet()) {
            List currentValue = (List)entry.getValue();
            int currentKey = (Integer)entry.getKey();
            if (currentInterval != null) {
                currentInterval.stop = currentKey - 1;
                list.add(currentInterval);
            }
            currentInterval = new Interval();
            currentInterval.start = currentKey;
            currentInterval.elements = new HashSet();
            if (currentValue == null) continue;
            currentInterval.elements.addAll(currentValue);
        }
        Assert.a(currentInterval.elements.size() == 0, "RangeMap did not end with an empty entry");
        return list;
    }

    public List getIntervals(int start, int stop) {
        ArrayList<Interval> list = new ArrayList<Interval>();
        Interval currentInterval = null;
        for (Map.Entry entry : this.getSubMap(start, stop + 1).entrySet()) {
            List currentValue = (List)entry.getValue();
            int currentKey = (Integer)entry.getKey();
            if (currentInterval == null && start < currentKey) {
                currentInterval = new Interval();
                currentInterval.start = start;
                currentInterval.elements = Collections.EMPTY_SET;
            }
            if (currentInterval != null) {
                currentInterval.stop = currentKey - 1;
                list.add(currentInterval);
            }
            currentInterval = new Interval();
            int n = currentInterval.start = currentKey > start ? currentKey : start;
            if (currentValue == null) {
                currentInterval.elements = Collections.EMPTY_SET;
                continue;
            }
            currentInterval.elements = new HashSet(currentValue);
        }
        if (currentInterval != null) {
            currentInterval.stop = stop;
            list.add(currentInterval);
        }
        return list;
    }

    public List getEmptyIntervals(int start, int totalSize) {
        Assert.a(start <= totalSize, "Start (", new Integer(start), ") must be less than stop (", new Integer(totalSize), ")");
        ArrayList<Interval> list = new ArrayList<Interval>();
        Interval currentInterval = null;
        boolean beforeStart = true;
        for (Map.Entry entry : this.map.entrySet()) {
            List currentValue = (List)entry.getValue();
            int currentKey = (Integer)entry.getKey();
            if (currentKey > totalSize) break;
            if (currentValue.size() == 0) {
                Assert.a(!beforeStart, "Map started with a 0 entry.");
                Assert.a(currentInterval == null, "Multiple 0 intervals in a row were detected.");
                if (currentKey < start) {
                    beforeStart = true;
                    continue;
                }
                currentInterval = new Interval();
                currentInterval.start = currentKey;
                continue;
            }
            if (beforeStart) {
                beforeStart = false;
                if (start < currentKey) {
                    currentInterval = new Interval();
                    currentInterval.start = start;
                }
            }
            if (currentInterval == null) continue;
            currentInterval.stop = currentKey - 1;
            list.add(currentInterval);
            currentInterval = null;
        }
        if (beforeStart) {
            Assert.a(currentInterval == null);
            currentInterval = new Interval();
            currentInterval.start = start;
        }
        if (currentInterval != null) {
            currentInterval.stop = totalSize;
            list.add(currentInterval);
        }
        return list;
    }

    public Set find(int argLow, int argHigh) {
        Iterator it = this.getSubMap(argLow, argHigh + 1).values().iterator();
        HashSet ret = new HashSet();
        while (it.hasNext()) {
            ArrayList l = (ArrayList)it.next();
            ret.addAll(l);
        }
        return ret;
    }

    public Set findContained(int argLow, int argHigh) {
        Iterator it = this.find(argLow, argHigh).iterator();
        HashSet ret = new HashSet();
        while (it.hasNext()) {
            Object o = it.next();
            Integer[] bounds = (Integer[])this.objectList.get(o);
            if (bounds[0] < argLow || bounds[1] > argHigh + 1) continue;
            ret.add(o);
        }
        return ret;
    }

    public Set findContaining(int argLow, int argHigh) {
        Iterator it = this.find(argLow, argHigh).iterator();
        HashSet ret = new HashSet();
        while (it.hasNext()) {
            Object o = it.next();
            Integer[] bounds = (Integer[])this.objectList.get(o);
            if (bounds[0] > argLow || bounds[1] < argHigh + 1) continue;
            ret.add(o);
        }
        return ret;
    }

    public boolean hasEntry(int argLow, int argHigh) {
        Iterator it = this.getSubMap(argLow, argHigh + 1).values().iterator();
        return it.hasNext() && (((ArrayList)it.next()).size() != 0 || it.hasNext());
    }

    protected SortedMap getSubMap(int argLow, int argHigh) {
        if (argLow > argHigh) {
            throw new IllegalArgumentException("Low end of range (" + argLow + ") is greater than high end (" + argHigh + ")");
        }
        Integer lowBound = new Integer(argLow + 1);
        Integer high = new Integer(argHigh);
        SortedMap lowMap = this.map.headMap(lowBound);
        if (lowMap.size() != 0) {
            lowBound = lowMap.lastKey();
        }
        return this.map.subMap(lowBound, high);
    }

    public void add(int argLow, int argHigh, Object o) {
        if (argLow > argHigh) {
            throw new IllegalArgumentException("Low end of range (" + argLow + ") is greater than high end (" + argHigh + ")");
        }
        if (this.objectList.containsKey(o)) {
            throw new IllegalArgumentException("RangeMap already contains " + o);
        }
        Integer low = new Integer(argLow);
        Integer high = new Integer(argHigh + 1);
        this.objectList.put(o, new Integer[]{low, high});
        this.makeSplitAt(low);
        this.makeSplitAt(high);
        for (ArrayList l : this.map.subMap(low, high).values()) {
            l.add(o);
        }
    }

    public boolean contains(Object o) {
        return this.objectList.get(o) != null;
    }

    public void remove(Object o) {
        Integer[] bounds = (Integer[])this.objectList.get(o);
        if (bounds == null) {
            throw new IllegalArgumentException("RangeMap does not contain: " + o);
        }
        this.objectList.remove(o);
        for (ArrayList l : this.map.subMap(bounds[0], bounds[1]).values()) {
            l.remove(o);
        }
        this.mergeAt(bounds[0]);
        this.mergeAt(bounds[1]);
    }

    private void mergeAt(Integer bound) {
        List startList = (List)this.map.get(bound);
        SortedMap lowMap = this.map.headMap(bound);
        if (lowMap.size() == 0) {
            if (startList.size() == 0) {
                this.map.remove(bound);
            }
        } else {
            List previousList = (List)lowMap.get(lowMap.lastKey());
            if (((Object)previousList).equals(startList)) {
                this.map.remove(bound);
            }
        }
    }

    private void makeSplitAt(Integer bound) {
        Object entry = this.map.get(bound);
        if (entry == null) {
            SortedMap headMap = this.map.headMap(bound);
            if (headMap.size() == 0) {
                this.map.put(bound, new ArrayList());
            } else {
                this.map.put(bound, new ArrayList((List)this.map.get(headMap.lastKey())));
            }
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("Range Map (x-y:count) ");
        Integer lastKey = null;
        int lastCount = 0;
        for (Integer key : this.map.keySet()) {
            if (lastKey != null) {
                ret.append(lastKey + "-" + (key - 1) + ":" + lastCount + " ");
            }
            lastKey = key;
            lastCount = ((List)this.map.get(key)).size();
        }
        ret.append(lastKey + "-end:" + lastCount);
        return ret.toString();
    }

    public static class Interval {
        public int start;
        public int stop;
        public Set elements;

        public Interval() {
        }

        public Interval(int start, int stop, Set elements) {
            this.start = start;
            this.stop = stop;
            this.elements = new HashSet(elements);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Interval)) {
                return false;
            }
            Interval interval = (Interval)obj;
            if (this.start != interval.start) {
                return false;
            }
            if (this.stop != interval.stop) {
                return false;
            }
            if (!this.elements.containsAll(interval.elements)) {
                return false;
            }
            return interval.elements.containsAll(this.elements);
        }

        public String toString() {
            String result = "";
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                result = result + iter.next().toString();
            }
            return "interval " + this.start + " -> " + this.stop + " : " + result + "\n";
        }

        public int getLength() {
            return 1 + this.stop - this.start;
        }
    }
}

