/*
 * Decompiled with CFR 0.152.
 */
package fmph.features.mitochondrion1;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import fmph.features.mitochondrion1.Mitochondrion1Tools;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeneConstraintsMitochondrion1
extends AbstractFeatureManager<Character>
implements FeatureManagerEdge<Character>,
FeatureManagerNode<Character> {
    private static final Log log = LogFactory.getLog(GeneConstraintsMitochondrion1.class);
    private static final long serialVersionUID = 3041359216265032511L;

    @Override
    public String getFeatureName(int featureIndex) {
        return "Gene constraints for the model Interval13";
    }

    @Override
    public int getNumFeatures() {
        return 0;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        Mitochondrion1Tools.verify(modelInfo);
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int prevState, int state, FeatureList result) {
        boolean valid = true;
        switch (Mitochondrion1Tools.edgeConstraints[prevState * Mitochondrion1Tools.numStates + state]) {
            case NONE: {
                break;
            }
            case NEVER: {
                Assert.a(false);
                break;
            }
            case PSTART: {
                int eind = Mitochondrion1Tools.check012(state - 1);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.startConstraintPlus(seq, pos);
                break;
            }
            case PDON: {
                int iind = Mitochondrion1Tools.check012(state - 4);
                int eind = Mitochondrion1Tools.check012(prevState - 1);
                if ((pos - eind + iind) % 3 == 0) break;
                valid = false;
                break;
            }
            case PACC: {
                int iind = Mitochondrion1Tools.check012(prevState - 4);
                int eind = Mitochondrion1Tools.check012(state - 1);
                if ((pos - eind + iind) % 3 == 0) break;
                valid = false;
                break;
            }
            case PSTOP: {
                int eind = Mitochondrion1Tools.check012(prevState - 1);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.stopEdgeConstraintPlus(seq, pos);
                break;
            }
            case MSTART: {
                int eind = Mitochondrion1Tools.check012(prevState - 7);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.startConstraintMinus(seq, pos);
                break;
            }
            case MDON: {
                int iind = Mitochondrion1Tools.check012(prevState - 10);
                int eind = Mitochondrion1Tools.check012(state - 7);
                if ((pos - eind - iind) % 3 == 0) break;
                valid = false;
                break;
            }
            case MACC: {
                int iind = Mitochondrion1Tools.check012(state - 10);
                int eind = Mitochondrion1Tools.check012(prevState - 7);
                if ((pos - eind - iind) % 3 == 0) break;
                valid = false;
                break;
            }
            case MSTOP: {
                int eind = Mitochondrion1Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) {
                    valid = false;
                    break;
                }
                valid = this.stopEdgeConstraintMinus(seq, pos);
                break;
            }
            case PCODE: {
                int eind = Mitochondrion1Tools.check012(state - 1);
                if ((pos - eind) % 3 != 2) break;
                valid = !this.stopNodeConstraintPlus(seq, pos);
                break;
            }
            case MCODE: {
                int eind = Mitochondrion1Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) break;
                valid = !this.stopNodeConstraintMinus(seq, pos);
                break;
            }
        }
        if (!valid) {
            result.invalidate();
        }
    }

    @Override
    public void evaluateNode(InputSequence<? extends Character> seq, int pos, int state, FeatureList result) {
        boolean valid = true;
        switch (Mitochondrion1Tools.nodeConstraints[state]) {
            case NONE: {
                break;
            }
            case NEVER: {
                Assert.a(false);
                break;
            }
            case PCODE: {
                int eind = Mitochondrion1Tools.check012(state - 1);
                if ((pos - eind) % 3 != 2) break;
                valid = !this.stopNodeConstraintPlus(seq, pos);
                break;
            }
            case MCODE: {
                int eind = Mitochondrion1Tools.check012(state - 7);
                if ((pos - eind) % 3 != 0) break;
                valid = !this.stopNodeConstraintMinus(seq, pos);
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        if (!valid) {
            result.invalidate();
        }
    }

    private boolean startConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        return seq.length() > pos + 2 && seq.getX(pos).charValue() == 'A' && seq.getX(pos + 1).charValue() == 'T' && (seq.getX(pos + 2).charValue() == 'G' || seq.getX(pos + 2).charValue() == 'A');
    }

    private boolean startConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        return pos >= 3 && (seq.getX(pos - 3).charValue() == 'C' || seq.getX(pos - 3).charValue() == 'T') && seq.getX(pos - 2).charValue() == 'A' && seq.getX(pos - 1).charValue() == 'T';
    }

    private boolean stopEdgeConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        if (pos < seq.length() - 2 && seq.getX(pos).charValue() == 'T') {
            return seq.getX(pos + 1).charValue() == 'A' && (seq.getX(pos + 2).charValue() == 'G' || seq.getX(pos + 2).charValue() == 'A');
        }
        return false;
    }

    private boolean stopEdgeConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        if (pos >= 3 && seq.getX(pos - 1).charValue() == 'A') {
            boolean ret = seq.getX(pos - 2).charValue() == 'T' && (seq.getX(pos - 3).charValue() == 'C' || seq.getX(pos - 3).charValue() == 'T');
            return ret;
        }
        return false;
    }

    private boolean stopNodeConstraintPlus(InputSequence<? extends Character> seq, int pos) {
        if (pos >= 2 && seq.getX(pos - 2).charValue() == 'T') {
            return seq.getX(pos - 1).charValue() == 'A' && (seq.getX(pos).charValue() == 'G' || seq.getX(pos).charValue() == 'A');
        }
        return false;
    }

    private boolean stopNodeConstraintMinus(InputSequence<? extends Character> seq, int pos) {
        if (pos < seq.length() - 2 && seq.getX(pos + 2).charValue() == 'A') {
            boolean ret = seq.getX(pos + 1).charValue() == 'T' && (seq.getX(pos).charValue() == 'C' || seq.getX(pos).charValue() == 'T');
            return ret;
        }
        return false;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

