/*
 * Decompiled with CFR 0.152.
 */
package fmph.io;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InputSequenceInt;
import calhoun.analysis.crf.io.InterleavedInputComponentBase;
import calhoun.util.Assert;
import calhoun.util.ErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class IntWithHeaderInput
extends InterleavedInputComponentBase {
    public static final String HEADER_START = ">";

    @Override
    public boolean read(BufferedReader r, Map<String, InputSequence<?>> output) throws IOException {
        int[] data = this.readSequence(r);
        if (data == null) {
            return false;
        }
        output.put(this.getName(), new InputSequenceInt(data));
        return true;
    }

    public int[] readSequence(BufferedReader r) throws IOException {
        String str = null;
        do {
            if ((str = r.readLine()) != null) continue;
            return null;
        } while (str.equals("") || str.startsWith(HEADER_START));
        int[] data = new int[str.length()];
        try {
            for (int i = 0; i < str.length(); ++i) {
                int temp = str.charAt(i) - 48;
                if (!(temp >= 0 && temp <= 9 || (temp = str.charAt(i) - 65 + 10) >= 10 && temp <= 35)) {
                    temp = str.charAt(i) - 97 + 36;
                    Assert.a(temp >= 36 && temp < 62, "Offending character was '" + str.charAt(i));
                }
                data[i] = temp;
            }
        }
        catch (NumberFormatException ex) {
            throw new ErrorException(ex);
        }
        return data;
    }

    @Override
    public void write(Writer w, Map<String, ? extends InputSequence<?>> data) throws IOException {
        this.writeSequence(w, ((InputSequenceInt)data.get(this.getName())).getData());
    }

    public void writeSequence(Writer w, int[] data) throws IOException {
        for (int i : data) {
            if (i < 10) {
                w.write(48 + i);
                continue;
            }
            if (i < 36) {
                w.write(65 + (i - 10));
                continue;
            }
            if (i < 62) {
                w.write(97 + (i - 36));
                continue;
            }
            throw new IOException();
        }
        w.write(10);
    }
}

