package mlproject.phylo;

public class Kimura80Model extends NucleotideSubstitutionModel {
    double ts, tv;

    public Kimura80Model(double ts, double tv) {
        this.ts = ts;
        this.tv = tv;
    }

    public double[][] getSubstitutionProbs(double time) {
        double s = (1 - Math.exp(-4 * tv * time)) / 4;
        double u = (1 + Math.exp(-4 * tv * time) - 2*Math.exp(-2 * (ts + tv) * time)) / 4;
        double r = 1 - 2*s - u;

        double[][] X = new double[4][4];
        int A=0, C=1, G=2, T=3;
        X[A][A]=r;         X[A][C]=s;        X[A][G]=u;       X[A][T]=s;
        X[C][A]=s;         X[C][C]=r;        X[C][G]=s;       X[C][T]=u; 
        X[G][A]=u;         X[G][C]=s;        X[G][G]=r;       X[G][T]=s;
        X[T][A]=s;         X[T][C]=u;        X[T][G]=s;       X[T][T]=r;
        
        return X;
    }
}
