package fmph.features.util;

import calhoun.util.Assert;

public class GeneticCodes {
    static String[][] codes = {
            { "The Standard Code",
            "FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "---M---------------M---------------M----------------------------"},
            { "The Vertebrate Mitochondrial Code",
            "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSS**VVVVAAAADDEEGGGG",
              "--------------------------------MMMM---------------M------------"},
            {"The Yeast Mitochondrial Code",
            "FFLLSSSSYY**CCWWTTTTPPPPHHQQRRRRIIMMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "----------------------------------MM----------------------------"},
            { "The Mold, Protozoan, and Coelenterate Mitochondrial Code"+
                 " and the Mycoplasma/Spiroplasma Code",
            "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "--MM---------------M------------MMMM---------------M------------"},
            { "The Invertebrate Mitochondrial Code",
            "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSSSSVVVVAAAADDEEGGGG",
              "---M----------------------------MMMM---------------M------------"},
            { "The Ciliate, Dasycladacean and Hexamita Nuclear Code",
            "FFLLSSSSYYQQCC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "-----------------------------------M----------------------------"},
            null,
            null,
            { "The Echinoderm and Flatworm Mitochondrial Code",
            "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIIMTTTTNNNKSSSSVVVVAAAADDEEGGGG",
              "-----------------------------------M---------------M------------"},
            { "The Euplotid Nuclear Code",
            "FFLLSSSSYY**CCCWLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "-----------------------------------M----------------------------"},
            {"The Bacterial and Plant Plastid Code",
            "FFLLSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "---M---------------M------------MMMM---------------M------------"},
            { "The Alternative Yeast Nuclear Code",
            "FFLLSSSSYY**CC*WLLLSPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "-------------------M---------------M----------------------------"},
            {"The Ascidian Mitochondrial Code",
            "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIMMTTTTNNKKSSGGVVVVAAAADDEEGGGG",
              "---M------------------------------MM---------------M------------"},
            {"The Alternative Flatworm Mitochondrial Code",
            "FFLLSSSSYYY*CCWWLLLLPPPPHHQQRRRRIIIMTTTTNNNKSSSSVVVVAAAADDEEGGGG",
              "-----------------------------------M----------------------------"},
            {"Blepharisma Nuclear Code",
            "FFLLSSSSYY*QCC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "-----------------------------------M----------------------------"},
            {"Chlorophycean Mitochondrial Code",
            "FFLLSSSSYY*LCC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "-----------------------------------M----------------------------"},
            null,
            null,
            null,
            null,
            { "Trematode Mitochondrial Code",
            "FFLLSSSSYY**CCWWLLLLPPPPHHQQRRRRIIMMTTTTNNNKSSSSVVVVAAAADDEEGGGG",
              "-----------------------------------M---------------M------------"},
            {"Scenedesmus obliquus mitochondrial Code",
            "FFLLSS*SYY*LCC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "-----------------------------------M----------------------------"},
            {"Thraustochytrium Mitochondrial Code",
            "FF*LSSSSYY**CC*WLLLLPPPPHHQQRRRRIIIMTTTTNNKKSSRRVVVVAAAADDEEGGGG",
              "--------------------------------M--M---------------M------------"}
            };
    
    public static String[] getCode(int code){
        Assert.a(code >0 && code < 24);
        return codes[code-1];
    }
    
    public static String getCodon(int codonNo){
        Assert.a(codonNo >=0 && codonNo < 64);
        String[] nucleotides = {"T","C","A","G"};
        int n1 = codonNo / 16;
        int n2 = (codonNo % 16) / 4;
        int n3 = (codonNo % 4);
        
        return nucleotides[n1]+nucleotides[n2]+nucleotides[n3];
    }
}
