package fmph.seq;

import calhoun.seq.KmerHasher;

public class ExtendedKmerHasher extends KmerHasher {
    public ExtendedKmerHasher(CharacterHash charHash, int length) {
            super(charHash,length);
    }
    
    /** Character hash function to use with DNA bases which included the ambiguity code "N".  Upper and lower case get hashed to the same value.  Handles only the 4 nucleotides (ACTG).  No other characters allowed. */
    public static CharacterHash TCAGother = new CharacterHash() {
            final char[] BASES = new char[] {'T','C','A','G','N'};
            public short getSize() { return 5;}
            public int hash(char a) {
                    switch(a) {
                            case 'T':
                            case 't':
                                    return 0;
                            case 'C':
                            case 'c':
                                    return 1;
                            case 'A':
                            case 'a':
                                    return 2;
                            case 'G':
                            case 'g':
                                    return 3;
                            default:
                                    return 4;
                    }
            }
            public char reverse(int a) {
                    return BASES[a];
            }
    };
    
    
    /** Character hash function to use with DNA bases which included the ambiguity code "N".  Upper and lower case get hashed to the same value.  Handles only the 4 nucleotides (ACTG).  No other characters allowed. */
    public static CharacterHash TCAGotherRC = new CharacterHash() {
            /* Like DNA, excapt never throws an exception; returns 4 if not ACGTN. */
            final char[] BASES = new char[] {'A','G','T','C','N'};
            public short getSize() { return 5;}
            public int hash(char a) {
                    switch(a) {
                            case 'C':
                            case 'c':
                                    return 3;
                            case 'T':
                            case 't':
                                    return 2;
                            case 'G':
                            case 'g':
                                    return 1;
                            case 'A':
                            case 'a':
                                    return 0;
                            default:
                                    return 4;
                    }
            }
            public char reverse(int a) {
                    return BASES[a];
            }
    };
}
