package mlproject.io;

import java.io.FileNotFoundException;
import java.io.IOException;

public class IntegerFastaInputReader implements InputReader<Integer>{
    FastaIterator fi;

    public IntegerFastaInputReader(String file) throws FileNotFoundException, IOException {
        fi = new FastaIterator(file);
    }
    
    public InputSequence<Integer> readNextSequence() throws IOException {
        String[] next = fi.next();
        if (next == null)
            return null;
        int[] seq = new int[next[1].length()];
        for (int i = 0; i < seq.length; i++) {
            int number = next[1].charAt(i) - '0';
            if(number < 0 || number > 9)
                throw new RuntimeException("Not a number character:"+next[1].charAt(i));       
            seq[i] = number;
        }
        
        return new IntegerInputSequence(next[0],seq);
                 
    }
}
