#! /usr/bin/perl -w
#Exctract names of genes inside genbank folder

use strict;
use Bio::SeqIO;
use Data::Dumper;

my %names;
foreach my $filename (glob("genbank/*.gb")) {
    my $stream = Bio::SeqIO->new(-file => $filename,
			      -format => 'GenBank');

   while ( my $seq = $stream->next_seq() ) {
	my @ann = $seq->get_SeqFeatures();
	#print Dumper(\@ann);
	foreach my $feature (@ann) {
	    if($feature->primary_tag() eq 'gene') {
		my $gene =  uc get_value($feature, 'gene');
		$gene =~ s/^\s+//;
		$gene =~ s/\s+$//;
  
		$names{$gene} = $gene;
	    }
	}

	

    }
}

foreach my $key (keys %names) {
		print "$key\n";
	}

sub get_value {
    my ($collection, $key) = @_;

    my @values = $collection->get_Annotations($key);
    return unless @values==1;
    return $values[0]->value();
}

