/**
 * Efficient calculation of breakpoint distance
 * Note: it computes the double of the breakpoint distance (we want to use integers, and breakpoint distance is a multiple of 0.5)
 * Warning: This class is not ready for usage in PIVO2. This class is using different diffs than the {@link DCJ} class.
 * Warning: does not implement the {@link EfficientDistance} interface  
 */
public class BreakpointDistance {
	
	public static int distance(Genome genome1, Genome genome2) {
		if (genome1.getGeneCount()!=genome2.getGeneCount()) throw new RuntimeException("not equal gene content");
		int distance = 0;
		for (int i = 0; i<genome1.getGeneCount()*2; i++) {
			if (genome1.getAdjacentExtremityByIndex(i)!=genome2.getAdjacentExtremityByIndex(i)) distance+=1;
		}
		return distance;
	}
	
	public static int distance(Genome genome, int[] diff) {
		return (int) diff.length/2;
	}
	
	public static int[] distance(Genome genome1, Genome genome2, int[][] diffs) {
		if (genome1.getGeneCount()!=genome2.getGeneCount()) throw new RuntimeException("not equal gene content");
		boolean[] difference = generateDifference(genome1, genome2);
		int distance = getDistanceFromDifference(difference);
		int[] distances = new int[diffs.length];
		for (int i = 0; i<diffs.length; i++) {
			int[] diff = diffs[i];
			distances[i] = distance;
			for (int d = 0; d<diff.length; d+=2) {
				if (genome1.getAdjacentExtremityByExtremity(diff[d])==diff[d+1]) distances[i]-=1;
				else if (difference[Genome.getAdjacencyIndexByExtremity(diff[d])]) /* nothing */;
				else distances[i]+=1;
			}
		}
		return distances;
	}
	
	public static int[][] distance(int[][] diffs1, Genome genome1, Genome genome2, int[][] diffs2) {
		if (genome1.getGeneCount()!=genome2.getGeneCount()) throw new RuntimeException("not equal gene content");
		boolean[] difference = generateDifference(genome1, genome2);
		int distance = getDistanceFromDifference(difference);
		int[][] distances = new int[diffs1.length][diffs2.length];
		for (int i = 0; i<diffs1.length; i++) {
			for (int j=0; j<diffs2.length; j++) {
				int[] diff1 = diffs1[i];
				int[] diff2 = diffs2[j];
				distances[i][j] = distance;
				
				for (int d = 0; d<diff1.length; d+=2) {
					if (genome2.getAdjacentExtremityByExtremity(diff1[d])==diff1[d+1]) distances[i][j]-=1;
					else if (difference[Genome.getAdjacencyIndexByExtremity(diff1[d])]) /* nothing */;
					else distances[i][j]+=1;
				}
				
				for (int d = 0; d<diff2.length; d+=2) {
					if (isDefinedInDiff(diff1, diff2[d], diff2[d+1]) || (genome1.getAdjacentExtremityByExtremity(diff2[d])==diff2[d+1] && isNotChangedInDiff(diff1, diff2[d]))) distances[i][j]-=1;
					else if ((difference[Genome.getAdjacencyIndexByExtremity(diff2[d])] && isNotDefinedBack(diff1, diff2[d], genome2)) || isDiffChanging(diff1, diff2[d], genome2)) /* nothing */;
					else distances[i][j]+=1;
				}
				
			}
		}
		return distances;
	}

	private static boolean isDefinedInDiff(int[] diff, int ext1, int ext2) {
		for (int i=0; i<diff.length; i+=2) {
			if (diff[i]==ext1 && diff[i+1]==ext2) return true;
		}
		return false;
	}
	
	private static boolean isNotChangedInDiff(int[] diff, int ext) {
		for (int i=0; i<diff.length; i+=2) {
			if (diff[i]==ext) return false;
		}
		return true;
	}
	
	private static boolean isNotDefinedBack(int[] diff, int ext, Genome genome) {
		for (int i=0; i<diff.length; i+=2) {
			if (diff[i]==ext) {
				if (genome.getAdjacentExtremityByExtremity(ext)==diff[i+1]) return false;
			}
		}
		return true;
	}
	
	private static boolean isDiffChanging(int[] diff, int ext, Genome genome) {
		for (int i=0; i<diff.length; i+=2) {
			if (diff[i]==ext) {
				if (genome.getAdjacentExtremityByExtremity(ext)==diff[i+1]) return false;
				else return true;
			}
		}
		return false;
	}
	

	private static boolean[] generateDifference(Genome genome1, Genome genome2) {
		boolean[] difference = new boolean[genome1.getGeneCount()*2];
		for (int i=0; i<difference.length; i++) {
			if (genome1.getAdjacentExtremityByIndex(i)!=genome2.getAdjacentExtremityByIndex(i)) difference[i] = true;
			else difference[i] = false;
		}
		return difference;
	}
	
	private static int getDistanceFromDifference(boolean[] difference) {
		int distance = 0;
		for (int i=0; i<difference.length; i++) if (difference[i]) distance += 1;
		return distance;
	}
	
	private static Neighbours neighbourGenerator(Genome genome) {
		Genome[] neighbours = new Genome[genome.getGeneCount()*2*(genome.getGeneCount()*2-1)];
		int[][] diffs = new int[genome.getGeneCount()*2*(genome.getGeneCount()*2-1)][];
		DCJ dcj = new DCJ();
		
		int nc = 0;
		for (int i=0; i<genome.getGeneCount()*2; i++) {
			for (int j=0; j<genome.getGeneCount()*2; j++) {
				if (i==j) continue;
				Genome mutated = new Genome(genome);
				int type = dcj.dcjOperation(mutated, i, j);
				neighbours[nc] = mutated;
				
				int extA = Genome.getExtremityByAdjacencyIndex(i);
				int extB = genome.getAdjacentExtremityByIndex(i);
				int extC = Genome.getExtremityByAdjacencyIndex(j);
				int extD = genome.getAdjacentExtremityByIndex(j);
				
				switch (type) {
				case 1:
					diffs[nc] = new int[4];
					diffs[nc][0] = extA; diffs[nc][1] = extC; diffs[nc][2] = extC; diffs[nc][3] = extA;
					break;
				case 2:
					diffs[nc] = new int[6];
					diffs[nc][0] = extA; diffs[nc][1] = extC; diffs[nc][2] = extC; diffs[nc][3] = extA; diffs[nc][4] = extB; diffs[nc][5] = extB;
					break;
				case 3:
					diffs[nc] = new int[6];
					diffs[nc][0] = extA; diffs[nc][1] = extC; diffs[nc][2] = extC; diffs[nc][3] = extA; diffs[nc][4] = extD; diffs[nc][5] = extD;
					break;
				case 4:
					if (extA==extD && extB==extC) {
						diffs[nc] = new int[4];
						diffs[nc][0] = extA; diffs[nc][1] = extA; diffs[nc][2] = extB; diffs[nc][3] = extB;
					}
					else {
						diffs[nc] = new int[8];
						diffs[nc][0] = extA; diffs[nc][1] = extD; diffs[nc][2] = extD; diffs[nc][3] = extA; diffs[nc][4] = extC; diffs[nc][5] = extB; diffs[nc][6] = extB; diffs[nc][7] = extC;
					}
					break;
				}
				nc++;
			}
		}
		Neighbours neigh = new Neighbours();
		neigh.neighbours = neighbours;
		neigh.diffs = diffs;
		return neigh;
	}
	
	public static void main(String[] args) {		
		System.out.println("Testing 1 vs 1");
		testing1vs1(150);
		
		System.out.println("Testing 1 vs Many");
		testing1vsMany(150);
		
		System.out.println("Testing Many vs Many");
		testingManyvsMany(60);
	}
	
	private static boolean testing1vs1(int geneCount) {
		Genome genome = new Genome(Genome.generateRandomGenomeString(geneCount));
		Neighbours neigh = neighbourGenerator(genome);
		boolean ok = true;
		for (int i=0; i<neigh.size(); i++) {
			if (distance(genome, neigh.diffs[i]) != distance(genome, neigh.neighbours[i])) {
				System.out.println(distance(genome, neigh.diffs[i]) + " vs " + distance(genome, neigh.neighbours[i]));
				ok = false;
			}
		}
		
		if (ok) System.out.println("OK");
		else System.out.println("ERROR");
		
		return ok;
	}
	
	private static boolean testing1vsMany(int geneCount) {
		Genome genome1 = new Genome(Genome.generateRandomGenomeString(geneCount));
		Genome genome2 = new Genome(Genome.generateRandomGenomeString(geneCount));
		Neighbours neigh2 = neighbourGenerator(genome2);

		long s1 = System.currentTimeMillis();
		int distances[] = distance(genome1, genome2, neigh2.diffs);
		long e1 = System.currentTimeMillis();
		
		boolean ok = true;
		for (int i=0; i<neigh2.size(); i++) {
			if (distances[i] != distance(genome1, neigh2.neighbours[i])) {
				System.out.println(distances[i] + " vs " + distance(genome1, neigh2.neighbours[i]));
				ok = false;
			}
		}
		
		long s2 = System.currentTimeMillis();
		for (int i=0; i<neigh2.size(); i++) {
			distance(genome1, neigh2.neighbours[i]);
		}
		long e2 = System.currentTimeMillis();
		
		if (ok) System.out.println("OK");
		else System.out.println("ERROR");
		System.out.println("effective: " + (e1-s1) + " vs bruteforce: " + (e2-s2));
		
		return ok;
	}
	
	private static boolean testingManyvsMany(int geneCount) {
		Genome genome1 = new Genome(Genome.generateRandomGenomeString(geneCount));
		Genome genome2 = new Genome(Genome.generateRandomGenomeString(geneCount));
		Neighbours neigh1 = neighbourGenerator(genome1);
		Neighbours neigh2 = neighbourGenerator(genome2);

		long s1 = System.currentTimeMillis();
		int distances[][] = distance(neigh1.diffs, genome1, genome2, neigh2.diffs);
		long e1 = System.currentTimeMillis();
		
		System.out.println("effective done");
		
 		boolean ok = true;
		for (int i=0; i<neigh1.size(); i++) {
			for (int j=0; j<neigh2.size(); j++) {
				if (distances[i][j] != distance(neigh1.neighbours[i], neigh2.neighbours[j])) {
					System.out.println(distances[i][j] + " vs " + distance(neigh1.neighbours[i], neigh2.neighbours[j]));
					ok = false;
				}
			}
		}
		
		long s2 = System.currentTimeMillis();
		for (int i=0; i<neigh1.size(); i++) {
			for (int j=0; j<neigh2.size(); j++) {
				distance(neigh1.neighbours[i], neigh2.neighbours[j]);
			}
		}
		long e2 = System.currentTimeMillis();
		
		if (ok) System.out.println("OK");
		else System.out.println("ERROR");
		System.out.println("effective: " + (e1-s1) + " vs bruteforce: " + (e2-s2));
		
		return ok;
	}
	
	static class Neighbours {
		public Genome[] neighbours;
		public int[][] diffs;
		
		public int size() {
			return neighbours.length;
		}
	}
}
