/**
 * Chromosome Penalty Calculator
 * Allows only one circular chromosome.
 */
public class ChromosomePenalty_C implements ChromosomePenalty {

	@Override
	public float calculatePenalty(Genome genome) {
		int[] chromosomes = genome.getChromosomeCount();
		return calculatePenalty(chromosomes[0], chromosomes[1]);
	}

	private float calculatePenalty(int linear, int circular) {
		return 2*(linear+Math.max(0, circular-1));
	}
}
