/**
 * An evolution model. For example: DCJ, Breakpoint, Reversal (Hannenhalli-Pevzner).
 */
public interface EvolutionModel {

	/**
	 * Computes the distance of two genomes. (Number of required operations to transform one genome into the other)
	 * @param genome1
	 * @param genome2
	 * @return distance of the genomes
	 */
	public int distance(Genome genome1, Genome genome2);
	
	/**
	 * Generates candidates. 
	 * @param phylogeny
	 */
	public void generateCandidates(Phylogeny phylogeny);
	
	/**
	 * Makes a random change in the genome.
	 * @param genome
	 */
	public void mutate(Genome genome);
	
	public EfficientDistance getEfficientDistance(Genome genome1, Genome genome2);
}
