import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;


public class TabuSearch {

	/**
	 * Maps: NodeName -> list of tabu Genomes
	 */
	private Map<String, Set<Genome>> tabuList = new HashMap<>();
	
	private float penalty = 0;
	
	public void setPenalty(float penalty) {
		this.penalty = penalty;
	}
	
	public TabuSearch() {
	}
	
	public float getPenalty(String nodeName, Genome genome) {
		Set<Genome> tabu = tabuList.get(nodeName);
		if (tabu!=null) {
			if (tabu.contains(genome)) {
				//System.out.println("Penalty " + penalty + " for genome " + genome.getStringRepresentation());
				return penalty;
			}
		}
		return 0;
	}

	public void loadTabuFromDirectory(String dir) {
		File[] files = new File(dir).listFiles();
		if (files==null) return;
		for (int i=0; i<files.length; i++) {
			try {
				loadTabu(new FileReader(files[i]));
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}
	}

	public void loadTabu(Reader reader) {
		BufferedReader br = new BufferedReader(reader);
		String line;
		try {
			while((line=br.readLine())!=null) {
				String parts[] = line.split("\\s+", 3);
				addTabu(parts[0], new Genome(parts[2]));
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void addTabu(String nodeName, Genome genome) {
		if (!tabuList.containsKey(nodeName)) {
			tabuList.put(nodeName, new HashSet<Genome>());
		}
		Set<Genome> tabu = tabuList.get(nodeName);
		tabu.add(genome);
	}
	
	public void addTabu(Phylogeny phylogeny) {
		for (PhylogenyNode node: phylogeny.getInternalNodes()) {
			addTabu(node.getOrganismName(), new Genome(node.getGenome()));
		}
	}
}
