#ifndef DIALOG_H
#define DIALOG_H

#include <QDialog>
#include "edge.h"
#include "helix.h"

namespace Ui {
    class Dialog;
}

class Dialog : public QDialog {
    Q_OBJECT
public:
    Dialog(Helix *helix, QWidget *parent = 0);
    ~Dialog();
    void done(int r);
    Helix *helix;

public slots:
    void accepted();

protected:
    void changeEvent(QEvent *e);
    QString correctValues();
    void getValues();

private:
    Ui::Dialog *ui;
};

#endif // DIALOG_H
