#include "helix.h"
#include <assert.h>
#include <iostream>
using namespace std;

QVariant Helix::itemChange(GraphicsItemChange change, const QVariant &value) {
    if (change == QGraphicsItem::ItemPositionChange) {
        if (this->a->loopEdge!=NULL) a->loopEdge->updatePosition();
        if (this->b->loopEdge!=NULL) b->loopEdge->updatePosition();
        if (this->c->loopEdge!=NULL) c->loopEdge->updatePosition();
        if (this->d->loopEdge!=NULL) d->loopEdge->updatePosition();
    }
    return value;
}

QRectF Helix::boundingRect() const {
    return QRectF(-8,-length/2+7,16,length-14);
}

Helix::~Helix() {
    delete a1;
    delete a2;
    a->helixEdge=NULL;
    b->helixEdge=NULL;
    c->helixEdge=NULL;
    d->helixEdge=NULL;
    delete a;
    delete b;
    delete c;
    delete d;
}

Helix::Helix(QGraphicsScene *scene, int length) {
  scene->addItem(this);
  if(length<20) { length=20; }
    this->length=length;
    this->setFlag(QGraphicsItem::ItemSendsGeometryChanges);
    this->setFlag(QGraphicsItem::ItemIsMovable);
    this->setFlag(QGraphicsItem::ItemIsSelectable);
    a=new Node('h', this);
    b=new Node('h', this);
    c=new Node('h', this);
    d=new Node('h', this);
    a->setPos(-8,length/2);
    b->setPos(-8,-length/2);
    c->setPos(8,length/2);
    d->setPos(8,-length/2);
    a1=new Edge(a,b,this,scene);
    a1->myHelix=this;
    a1->setFlag(QGraphicsItem::ItemIsSelectable,false);
    a2=new Edge(c,d,this,scene);
    a2->myHelix=this;
    a2->setFlag(QGraphicsItem::ItemIsSelectable,false);
    a->helixEdge=a1;
    b->helixEdge=a1;
    c->helixEdge=a2;
    d->helixEdge=a2;
    a1->updatePosition();
    a2->updatePosition();
    this->mismdown=0;
    this->mismup=0;
    this->relation=false;
    this->relationString = "TGCA";
    this->insertions = 0;
    this->insertionLetter = "N";
    this->upstream = QString(length/10-1, 'N');
    this->downstream = QString(length/10-1, 'N');
}

Node* Helix::opposite(Node *node) {
    if (node==a) return c;
    if (node==b) return d;
    if (node==c) return a;
    assert(node==d);
    return b;
}

Edge* Helix::opposite(Edge *edge) {
  if(edge==a1) return a2;
  assert(edge==a2);
  return a1;
}

void Helix::resize(int length){
    if (length<20) length=20;
    this->prepareGeometryChange();
    this->length=length;
    a->setPos(-8,length/2);
    b->setPos(-8,-length/2);
    c->setPos(8,length/2);
    d->setPos(8,-length/2);
    a1->updatePosition();
    a2->updatePosition();
    if (this->a->loopEdge!=NULL) a->loopEdge->updatePosition();
    if (this->b->loopEdge!=NULL) b->loopEdge->updatePosition();
    if (this->c->loopEdge!=NULL) c->loopEdge->updatePosition();
    if (this->d->loopEdge!=NULL) d->loopEdge->updatePosition();

}

void Helix::setEdges(Edge *edge, int n) {
    Edge *other;
    if (a1==edge) other=a2;
    else other=a1;
    QString id;
    if (this->relation==true) id="r";
    else id="h";
    id.append(QString::number(n));
    edge->id=id;
    id.append("'");
    other->id=id;
    edge->loop=this->upstream;
    other->loop=this->downstream;
    edge->mism=this->mismup;
    other->mism=this->mismdown;
}


void Helix::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                  QWidget *widget) {
    QPen pen;
    pen.setWidth(2);
    pen.setColor(Qt::black);
    painter->setPen(pen);
    if (this->isSelected()) {

    }
    for (int i=1;i<length/10;i++) {
        painter->drawLine(QPoint(-8,i*10-length/2),QPoint(8,i*10-length/2));
    }

}
