#include "loopdialog.h"
#include "ui_loopdialog.h"

loopDialog::loopDialog(Edge *edge, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::loopDialog)
{
    ui->setupUi(this);
    this->edge=edge;
    ui->lineEdit->setText(edge->loop);
    ui->spinBox->setValue(edge->mism);
    connect(ui->buttonBox, SIGNAL(accepted()), this, SLOT(accepted()));

}

void loopDialog::accepted() {
    edge->loop=ui->lineEdit->text();
    edge->mism=ui->spinBox->value();
}


loopDialog::~loopDialog()
{
    delete ui;
}

void loopDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
