/*
 * $Id: matrix.h,v 1.3 2012-02-25 16:38:32 laci Exp $
 *
 * Project      : RNA motif searching in genomic sequences
 * Description  : the header file for matrix.cpp
 *
 * Author       : Ladislav Rampasek <rampasek@gmail.com>
 * Institution  : Comenius University in Bratislava
 *
 */

#include <vector>
#include <cstdarg>
#include <set>
#include <tr1/unordered_set>
#include <tr1/array>

using namespace std;

//data structure for dynamic programming
class Matrix{
    public:
        Matrix(){Matrix(1);};
        Matrix(unsigned int num_dimensions):num_dimensions(num_dimensions){};

        //bool get2(int num_args, ...);
        bool get(tr1::array<int, 7> &key);
        //void set2(int num_args, ...);
        void set(tr1::array<int, 7> &key);
        void clear(){ matrix.clear(); };
        bool empty(){ return matrix.empty(); };
        void set_dimensions(int new_num_dimensions){ num_dimensions=new_num_dimensions; clear(); };
    private:
        unsigned int num_dimensions;
        std::set < unsigned long long > matrix;
};
